#include <bnb/glsl.frag>
#include <bnb/lut.glsl>
#include <bnb/guided_filter.glsl>
precision highp float;
precision highp int;

BNB_IN(0) vec2 var_uv;

BNB_DECLARE_SAMPLER_2D(2, 3, glfx_BACKGROUND);

BNB_DECLARE_SAMPLER_2D(0, 1, lut);

const int radius = 6;
const float eps = 0.1f;
const float cut = 0.7f;
const float cut_pow = 0.3f;

void main()
{
    vec2 uv = var_uv;

    float fg_mask = 1.f;

    vec4 source_color = BNB_TEXTURE_2D(BNB_SAMPLER_2D(glfx_BACKGROUND), uv);
    vec4 mean = bnb_guided_filter(BNB_PASS_SAMPLER_ARGUMENT(glfx_BACKGROUND), uv, radius, eps);
    fg_mask = clamp(dot(mean.rgb, source_color.rgb) + mean.a, 0.f, 1.f);
    fg_mask = cut_and_rescale(fg_mask, cut, cut_pow);
    float complete_mask = clamp(fg_mask, 0.f, 1.f);
    
    vec4 lut_color = bnb_texture_lookup_512(BNB_TEXTURE_2D(BNB_SAMPLER_2D(glfx_BACKGROUND), uv),BNB_PASS_SAMPLER_ARGUMENT(lut));

    bnb_FragColor = vec4(lut_color.rgb, fg_mask);
}
